
####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was ArborXConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

set(CMAKE_MODULE_PATH ${CMAKE_CURRENT_LIST_DIR} ${CMAKE_MODULE_PATH})

include(CMakeFindDependencyMacro)

find_package(Kokkos QUIET)
if(NOT Kokkos_FOUND)
  # If Kokkos was not found, try to use Kokkos used when building ArborX
  set(Kokkos_DIR /var/jenkins/workspace/ArborX_nightly/install-kokkos/lib/cmake/Kokkos)
  find_dependency(Kokkos)
endif()

include("${CMAKE_CURRENT_LIST_DIR}/ArborXSettings.cmake")
if(Kokkos_ENABLE_HIP AND ARBORX_ENABLE_ROCTHRUST)
  find_dependency(rocthrust)
endif()
if(Kokkos_ENABLE_SYCL AND ARBORX_ENABLE_ONEDPL)
  set(ARBORX_CXX_COMPILER_BUNDLED_ONEDPL )
  if(NOT ARBORX_CXX_COMPILER_BUNDLED_ONEDPL)
    find_dependency(oneDPL)
  endif()
  unset(ARBORX_CXX_COMPILER_BUNDLED_ONEDPL)
endif()
if(ARBORX_ENABLE_MPI)
  find_dependency(MPI)
endif()

include("${CMAKE_CURRENT_LIST_DIR}/ArborXTargets.cmake")
check_required_components(ArborX)
