# Copyright Spack Project Developers. See COPYRIGHT file for details.
#
# SPDX-License-Identifier: (Apache-2.0 OR MIT)
"""Schema for bootstrap.yaml configuration file."""
from typing import Any, Dict

#: Schema of a single source
_source_schema: Dict[str, Any] = {
    "type": "object",
    "properties": {"name": {"type": "string"}, "metadata": {"type": "string"}},
    "additionalProperties": False,
    "required": ["name", "metadata"],
}

properties: Dict[str, Any] = {
    "bootstrap": {
        "type": "object",
        "properties": {
            "enable": {"type": "boolean"},
            "root": {"type": "string"},
            "sources": {"type": "array", "items": _source_schema},
            "trusted": {"type": "object", "additionalProperties": {"type": "boolean"}},
        },
    }
}

#: Full schema with metadata
schema = {
    "$schema": "http://json-schema.org/draft-07/schema#",
    "title": "Spack bootstrap configuration file schema",
    "type": "object",
    "additionalProperties": False,
    "properties": properties,
}
