# Copyright Spack Project Developers. See COPYRIGHT file for details.
#
# SPDX-License-Identifier: (Apache-2.0 OR MIT)
from typing import Any, Dict

#: Properties for inclusion in other schemas
properties: Dict[str, Any] = {
    "upstreams": {
        "type": "object",
        "default": {},
        "description": "Configuration for chaining Spack installations. Point this Spack "
        "instance to other Spack installations to use their installed packages",
        "additionalProperties": {
            "type": "object",
            "default": {},
            "additionalProperties": False,
            "description": "Named upstream Spack instance configuration",
            "properties": {
                "install_tree": {
                    "type": "string",
                    "description": "Path to the opt/spack directory of the upstream Spack "
                    "installation (or the install_tree root from its config.yaml)",
                },
                "modules": {
                    "type": "object",
                    "description": "Configuration to use modules generated by the upstream "
                    "Spack instance",
                    "properties": {
                        "tcl": {
                            "type": "string",
                            "description": "Path to TCL modules directory of the upstream "
                            "instance",
                        },
                        "lmod": {
                            "type": "string",
                            "description": "Path to Lmod modules directory of the upstream "
                            "instance",
                        },
                    },
                },
            },
        },
    }
}

#: Full schema with metadata
schema = {
    "$schema": "http://json-schema.org/draft-07/schema#",
    "title": "Spack core configuration file schema",
    "type": "object",
    "additionalProperties": False,
    "properties": properties,
}
