# Copyright Spack Project Developers. See COPYRIGHT file for details.
#
# SPDX-License-Identifier: (Apache-2.0 OR MIT)
from spack.main import SpackCommand


def test_reuse_after_help():
    """Test `spack help` can be called twice with the same SpackCommand."""
    help_cmd = SpackCommand("help")
    help_cmd()
    help_cmd()


def test_help():
    """Sanity check the help command to make sure it works."""
    help_cmd = SpackCommand("help")
    out = help_cmd()
    assert "Common spack commands:" in out
    assert "Options:" in out


def test_help_all():
    """Test the spack help --all flag"""
    help_cmd = SpackCommand("help")
    out = help_cmd("--all")
    assert "Commands:" in out
    assert "Options:" in out


def test_help_spec():
    """Test the spack help --spec flag"""
    help_cmd = SpackCommand("help")
    out = help_cmd("--spec")
    assert "spec expression syntax:" in out


def test_help_subcommand():
    """Test the spack help subcommand argument"""
    help_cmd = SpackCommand("help")
    out = help_cmd("help")
    assert "get help on spack and its commands" in out
