include(FindPackageHandleStandardArgs)

find_library(AMD_HIP_LIBRARY amdhip64 PATHS ${ROCM_PATH} ENV ROCM_PATH PATH_SUFFIXES lib)
find_library(HSA_RUNTIME_LIBRARY hsa-runtime64 PATHS ${ROCM_PATH} ENV ROCM_PATH PATH_SUFFIXES lib)

find_package_handle_standard_args(TPLROCM DEFAULT_MSG AMD_HIP_LIBRARY HSA_RUNTIME_LIBRARY)

kokkos_create_imported_tpl(
  ROCM
  INTERFACE
  LINK_LIBRARIES
  ${HSA_RUNTIME_LIBRARY}
  ${AMD_HIP_LIBRARY}
  COMPILE_DEFINITIONS
  __HIP_ROCclr__
)
